package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PgPgUserConfigPrivatelinkAccessArgs private(
  pg: Output[Option[Boolean]],
  pgbouncer: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object PgPgUserConfigPrivatelinkAccessArgs:
  def apply(
    pg: Input.Optional[Boolean] = None,
    pgbouncer: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None
  )(using Context): PgPgUserConfigPrivatelinkAccessArgs =
    new PgPgUserConfigPrivatelinkAccessArgs(
      pg = pg.asOptionOutput(isSecret = false),
      pgbouncer = pgbouncer.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false)
    )
