package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PgPgUserConfigPublicAccessArgs private(
  pg: Output[Option[Boolean]],
  pgbouncer: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object PgPgUserConfigPublicAccessArgs:
  def apply(
    pg: Input.Optional[Boolean] = None,
    pgbouncer: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None
  )(using Context): PgPgUserConfigPublicAccessArgs =
    new PgPgUserConfigPublicAccessArgs(
      pg = pg.asOptionOutput(isSecret = false),
      pgbouncer = pgbouncer.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false)
    )
