package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class RedisRedisUserConfigPrivatelinkAccessArgs private(
  prometheus: Output[Option[Boolean]],
  redis: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object RedisRedisUserConfigPrivatelinkAccessArgs:
  def apply(
    prometheus: Input.Optional[Boolean] = None,
    redis: Input.Optional[Boolean] = None
  )(using Context): RedisRedisUserConfigPrivatelinkAccessArgs =
    new RedisRedisUserConfigPrivatelinkAccessArgs(
      prometheus = prometheus.asOptionOutput(isSecret = false),
      redis = redis.asOptionOutput(isSecret = false)
    )
