package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class RedisServiceIntegrationArgs private(
  integrationType: Output[String],
  sourceServiceName: Output[String]
) derives Encoder, ArgsEncoder

object RedisServiceIntegrationArgs:
  def apply(
    integrationType: Input[String],
    sourceServiceName: Input[String]
  )(using Context): RedisServiceIntegrationArgs =
    new RedisServiceIntegrationArgs(
      integrationType = integrationType.asOutput(isSecret = false),
      sourceServiceName = sourceServiceName.asOutput(isSecret = false)
    )
