package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationClickhousePostgresqlUserConfigDatabaseArgs private(
  database: Output[Option[String]],
  schema: Output[Option[String]]
) derives Encoder, ArgsEncoder

object ServiceIntegrationClickhousePostgresqlUserConfigDatabaseArgs:
  def apply(
    database: Input.Optional[String] = None,
    schema: Input.Optional[String] = None
  )(using Context): ServiceIntegrationClickhousePostgresqlUserConfigDatabaseArgs =
    new ServiceIntegrationClickhousePostgresqlUserConfigDatabaseArgs(
      database = database.asOptionOutput(isSecret = false),
      schema = schema.asOptionOutput(isSecret = false)
    )
