package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationDatadogUserConfigArgs private(
  datadogDbmEnabled: Output[Option[Boolean]],
  datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.ServiceIntegrationDatadogUserConfigDatadogTagArgs]]],
  excludeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]],
  excludeTopics: Output[Option[scala.collection.immutable.List[String]]],
  includeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]],
  includeTopics: Output[Option[scala.collection.immutable.List[String]]],
  kafkaCustomMetrics: Output[Option[scala.collection.immutable.List[String]]],
  maxJmxMetrics: Output[Option[Int]],
  opensearch: Output[Option[besom.api.aiven.inputs.ServiceIntegrationDatadogUserConfigOpensearchArgs]],
  redis: Output[Option[besom.api.aiven.inputs.ServiceIntegrationDatadogUserConfigRedisArgs]]
) derives Encoder, ArgsEncoder

object ServiceIntegrationDatadogUserConfigArgs:
  def apply(
    datadogDbmEnabled: Input.Optional[Boolean] = None,
    datadogTags: Input.Optional[List[Input[besom.api.aiven.inputs.ServiceIntegrationDatadogUserConfigDatadogTagArgs]]] = None,
    excludeConsumerGroups: Input.Optional[List[Input[String]]] = None,
    excludeTopics: Input.Optional[List[Input[String]]] = None,
    includeConsumerGroups: Input.Optional[List[Input[String]]] = None,
    includeTopics: Input.Optional[List[Input[String]]] = None,
    kafkaCustomMetrics: Input.Optional[List[Input[String]]] = None,
    maxJmxMetrics: Input.Optional[Int] = None,
    opensearch: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationDatadogUserConfigOpensearchArgs] = None,
    redis: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationDatadogUserConfigRedisArgs] = None
  )(using Context): ServiceIntegrationDatadogUserConfigArgs =
    new ServiceIntegrationDatadogUserConfigArgs(
      datadogDbmEnabled = datadogDbmEnabled.asOptionOutput(isSecret = false),
      datadogTags = datadogTags.asOptionOutput(isSecret = false),
      excludeConsumerGroups = excludeConsumerGroups.asOptionOutput(isSecret = false),
      excludeTopics = excludeTopics.asOptionOutput(isSecret = false),
      includeConsumerGroups = includeConsumerGroups.asOptionOutput(isSecret = false),
      includeTopics = includeTopics.asOptionOutput(isSecret = false),
      kafkaCustomMetrics = kafkaCustomMetrics.asOptionOutput(isSecret = false),
      maxJmxMetrics = maxJmxMetrics.asOptionOutput(isSecret = false),
      opensearch = opensearch.asOptionOutput(isSecret = false),
      redis = redis.asOptionOutput(isSecret = false)
    )
