package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationEndpointDatadogUserConfigArgs private(
  datadogApiKey: Output[String],
  datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.ServiceIntegrationEndpointDatadogUserConfigDatadogTagArgs]]],
  disableConsumerStats: Output[Option[Boolean]],
  kafkaConsumerCheckInstances: Output[Option[Int]],
  kafkaConsumerStatsTimeout: Output[Option[Int]],
  maxPartitionContexts: Output[Option[Int]],
  site: Output[Option[String]]
) derives Encoder, ArgsEncoder

object ServiceIntegrationEndpointDatadogUserConfigArgs:
  def apply(
    datadogApiKey: Input[String],
    datadogTags: Input.Optional[List[Input[besom.api.aiven.inputs.ServiceIntegrationEndpointDatadogUserConfigDatadogTagArgs]]] = None,
    disableConsumerStats: Input.Optional[Boolean] = None,
    kafkaConsumerCheckInstances: Input.Optional[Int] = None,
    kafkaConsumerStatsTimeout: Input.Optional[Int] = None,
    maxPartitionContexts: Input.Optional[Int] = None,
    site: Input.Optional[String] = None
  )(using Context): ServiceIntegrationEndpointDatadogUserConfigArgs =
    new ServiceIntegrationEndpointDatadogUserConfigArgs(
      datadogApiKey = datadogApiKey.asOutput(isSecret = true),
      datadogTags = datadogTags.asOptionOutput(isSecret = false),
      disableConsumerStats = disableConsumerStats.asOptionOutput(isSecret = false),
      kafkaConsumerCheckInstances = kafkaConsumerCheckInstances.asOptionOutput(isSecret = false),
      kafkaConsumerStatsTimeout = kafkaConsumerStatsTimeout.asOptionOutput(isSecret = false),
      maxPartitionContexts = maxPartitionContexts.asOptionOutput(isSecret = false),
      site = site.asOptionOutput(isSecret = false)
    )
