package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs private(
  accessKey: Output[String],
  logGroupName: Output[Option[String]],
  region: Output[String],
  secretKey: Output[String]
) derives Encoder, ArgsEncoder

object ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs:
  def apply(
    accessKey: Input[String],
    logGroupName: Input.Optional[String] = None,
    region: Input[String],
    secretKey: Input[String]
  )(using Context): ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs =
    new ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs(
      accessKey = accessKey.asOutput(isSecret = false),
      logGroupName = logGroupName.asOptionOutput(isSecret = false),
      region = region.asOutput(isSecret = false),
      secretKey = secretKey.asOutput(isSecret = false)
    )
