package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs private(
  ca: Output[Option[String]],
  indexDaysMax: Output[Option[Int]],
  indexPrefix: Output[String],
  timeout: Output[Option[Double]],
  url: Output[String]
) derives Encoder, ArgsEncoder

object ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs:
  def apply(
    ca: Input.Optional[String] = None,
    indexDaysMax: Input.Optional[Int] = None,
    indexPrefix: Input[String],
    timeout: Input.Optional[Double] = None,
    url: Input[String]
  )(using Context): ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs =
    new ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs(
      ca = ca.asOptionOutput(isSecret = false),
      indexDaysMax = indexDaysMax.asOptionOutput(isSecret = false),
      indexPrefix = indexPrefix.asOutput(isSecret = false),
      timeout = timeout.asOptionOutput(isSecret = false),
      url = url.asOutput(isSecret = false)
    )
