package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationEndpointExternalKafkaUserConfigArgs private(
  bootstrapServers: Output[String],
  saslMechanism: Output[Option[String]],
  saslPlainPassword: Output[Option[String]],
  saslPlainUsername: Output[Option[String]],
  securityProtocol: Output[String],
  sslCaCert: Output[Option[String]],
  sslClientCert: Output[Option[String]],
  sslClientKey: Output[Option[String]],
  sslEndpointIdentificationAlgorithm: Output[Option[String]]
) derives Encoder, ArgsEncoder

object ServiceIntegrationEndpointExternalKafkaUserConfigArgs:
  def apply(
    bootstrapServers: Input[String],
    saslMechanism: Input.Optional[String] = None,
    saslPlainPassword: Input.Optional[String] = None,
    saslPlainUsername: Input.Optional[String] = None,
    securityProtocol: Input[String],
    sslCaCert: Input.Optional[String] = None,
    sslClientCert: Input.Optional[String] = None,
    sslClientKey: Input.Optional[String] = None,
    sslEndpointIdentificationAlgorithm: Input.Optional[String] = None
  )(using Context): ServiceIntegrationEndpointExternalKafkaUserConfigArgs =
    new ServiceIntegrationEndpointExternalKafkaUserConfigArgs(
      bootstrapServers = bootstrapServers.asOutput(isSecret = false),
      saslMechanism = saslMechanism.asOptionOutput(isSecret = false),
      saslPlainPassword = saslPlainPassword.asOptionOutput(isSecret = true),
      saslPlainUsername = saslPlainUsername.asOptionOutput(isSecret = false),
      securityProtocol = securityProtocol.asOutput(isSecret = false),
      sslCaCert = sslCaCert.asOptionOutput(isSecret = false),
      sslClientCert = sslClientCert.asOptionOutput(isSecret = false),
      sslClientKey = sslClientKey.asOptionOutput(isSecret = false),
      sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm.asOptionOutput(isSecret = false)
    )
