package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs private(
  authentication: Output[String],
  basicAuthPassword: Output[Option[String]],
  basicAuthUsername: Output[Option[String]],
  url: Output[String]
) derives Encoder, ArgsEncoder

object ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs:
  def apply(
    authentication: Input[String],
    basicAuthPassword: Input.Optional[String] = None,
    basicAuthUsername: Input.Optional[String] = None,
    url: Input[String]
  )(using Context): ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs =
    new ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs(
      authentication = authentication.asOutput(isSecret = false),
      basicAuthPassword = basicAuthPassword.asOptionOutput(isSecret = true),
      basicAuthUsername = basicAuthUsername.asOptionOutput(isSecret = false),
      url = url.asOutput(isSecret = false)
    )
