package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationEndpointJolokiaUserConfigArgs private(
  basicAuthPassword: Output[Option[String]],
  basicAuthUsername: Output[Option[String]]
) derives Encoder, ArgsEncoder

object ServiceIntegrationEndpointJolokiaUserConfigArgs:
  def apply(
    basicAuthPassword: Input.Optional[String] = None,
    basicAuthUsername: Input.Optional[String] = None
  )(using Context): ServiceIntegrationEndpointJolokiaUserConfigArgs =
    new ServiceIntegrationEndpointJolokiaUserConfigArgs(
      basicAuthPassword = basicAuthPassword.asOptionOutput(isSecret = true),
      basicAuthUsername = basicAuthUsername.asOptionOutput(isSecret = false)
    )
