package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationKafkaConnectUserConfigKafkaConnectArgs private(
  configStorageTopic: Output[Option[String]],
  groupId: Output[Option[String]],
  offsetStorageTopic: Output[Option[String]],
  statusStorageTopic: Output[Option[String]]
) derives Encoder, ArgsEncoder

object ServiceIntegrationKafkaConnectUserConfigKafkaConnectArgs:
  def apply(
    configStorageTopic: Input.Optional[String] = None,
    groupId: Input.Optional[String] = None,
    offsetStorageTopic: Input.Optional[String] = None,
    statusStorageTopic: Input.Optional[String] = None
  )(using Context): ServiceIntegrationKafkaConnectUserConfigKafkaConnectArgs =
    new ServiceIntegrationKafkaConnectUserConfigKafkaConnectArgs(
      configStorageTopic = configStorageTopic.asOptionOutput(isSecret = false),
      groupId = groupId.asOptionOutput(isSecret = false),
      offsetStorageTopic = offsetStorageTopic.asOptionOutput(isSecret = false),
      statusStorageTopic = statusStorageTopic.asOptionOutput(isSecret = false)
    )
