package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationMetricsUserConfigArgs private(
  database: Output[Option[String]],
  retentionDays: Output[Option[Int]],
  roUsername: Output[Option[String]],
  sourceMysql: Output[Option[besom.api.aiven.inputs.ServiceIntegrationMetricsUserConfigSourceMysqlArgs]],
  username: Output[Option[String]]
) derives Encoder, ArgsEncoder

object ServiceIntegrationMetricsUserConfigArgs:
  def apply(
    database: Input.Optional[String] = None,
    retentionDays: Input.Optional[Int] = None,
    roUsername: Input.Optional[String] = None,
    sourceMysql: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationMetricsUserConfigSourceMysqlArgs] = None,
    username: Input.Optional[String] = None
  )(using Context): ServiceIntegrationMetricsUserConfigArgs =
    new ServiceIntegrationMetricsUserConfigArgs(
      database = database.asOptionOutput(isSecret = false),
      retentionDays = retentionDays.asOptionOutput(isSecret = false),
      roUsername = roUsername.asOptionOutput(isSecret = false),
      sourceMysql = sourceMysql.asOptionOutput(isSecret = false),
      username = username.asOptionOutput(isSecret = false)
    )
