package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ServiceIntegrationMetricsUserConfigSourceMysqlTelegrafArgs private(
  gatherEventWaits: Output[Option[Boolean]],
  gatherFileEventsStats: Output[Option[Boolean]],
  gatherIndexIoWaits: Output[Option[Boolean]],
  gatherInfoSchemaAutoInc: Output[Option[Boolean]],
  gatherInnodbMetrics: Output[Option[Boolean]],
  gatherPerfEventsStatements: Output[Option[Boolean]],
  gatherProcessList: Output[Option[Boolean]],
  gatherSlaveStatus: Output[Option[Boolean]],
  gatherTableIoWaits: Output[Option[Boolean]],
  gatherTableLockWaits: Output[Option[Boolean]],
  gatherTableSchema: Output[Option[Boolean]],
  perfEventsStatementsDigestTextLimit: Output[Option[Int]],
  perfEventsStatementsLimit: Output[Option[Int]],
  perfEventsStatementsTimeLimit: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object ServiceIntegrationMetricsUserConfigSourceMysqlTelegrafArgs:
  def apply(
    gatherEventWaits: Input.Optional[Boolean] = None,
    gatherFileEventsStats: Input.Optional[Boolean] = None,
    gatherIndexIoWaits: Input.Optional[Boolean] = None,
    gatherInfoSchemaAutoInc: Input.Optional[Boolean] = None,
    gatherInnodbMetrics: Input.Optional[Boolean] = None,
    gatherPerfEventsStatements: Input.Optional[Boolean] = None,
    gatherProcessList: Input.Optional[Boolean] = None,
    gatherSlaveStatus: Input.Optional[Boolean] = None,
    gatherTableIoWaits: Input.Optional[Boolean] = None,
    gatherTableLockWaits: Input.Optional[Boolean] = None,
    gatherTableSchema: Input.Optional[Boolean] = None,
    perfEventsStatementsDigestTextLimit: Input.Optional[Int] = None,
    perfEventsStatementsLimit: Input.Optional[Int] = None,
    perfEventsStatementsTimeLimit: Input.Optional[Int] = None
  )(using Context): ServiceIntegrationMetricsUserConfigSourceMysqlTelegrafArgs =
    new ServiceIntegrationMetricsUserConfigSourceMysqlTelegrafArgs(
      gatherEventWaits = gatherEventWaits.asOptionOutput(isSecret = false),
      gatherFileEventsStats = gatherFileEventsStats.asOptionOutput(isSecret = false),
      gatherIndexIoWaits = gatherIndexIoWaits.asOptionOutput(isSecret = false),
      gatherInfoSchemaAutoInc = gatherInfoSchemaAutoInc.asOptionOutput(isSecret = false),
      gatherInnodbMetrics = gatherInnodbMetrics.asOptionOutput(isSecret = false),
      gatherPerfEventsStatements = gatherPerfEventsStatements.asOptionOutput(isSecret = false),
      gatherProcessList = gatherProcessList.asOptionOutput(isSecret = false),
      gatherSlaveStatus = gatherSlaveStatus.asOptionOutput(isSecret = false),
      gatherTableIoWaits = gatherTableIoWaits.asOptionOutput(isSecret = false),
      gatherTableLockWaits = gatherTableLockWaits.asOptionOutput(isSecret = false),
      gatherTableSchema = gatherTableSchema.asOptionOutput(isSecret = false),
      perfEventsStatementsDigestTextLimit = perfEventsStatementsDigestTextLimit.asOptionOutput(isSecret = false),
      perfEventsStatementsLimit = perfEventsStatementsLimit.asOptionOutput(isSecret = false),
      perfEventsStatementsTimeLimit = perfEventsStatementsTimeLimit.asOptionOutput(isSecret = false)
    )
