package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class AccountAuthenticationSamlFieldMapping private(
  email: Option[String],
  firstName: Option[String],
  identity: Option[String],
  lastName: Option[String],
  realName: Option[String]
) derives Decoder

object AccountAuthenticationSamlFieldMapping:
  given outputOps: {} with
    extension(output: Output[AccountAuthenticationSamlFieldMapping])
      def email: Output[Option[String]] = output.map(_.email)
      def firstName: Output[Option[String]] = output.map(_.firstName)
      def identity: Output[Option[String]] = output.map(_.identity)
      def lastName: Output[Option[String]] = output.map(_.lastName)
      def realName: Output[Option[String]] = output.map(_.realName)

  given optionOutputOps: {} with
    extension(output: Output[Option[AccountAuthenticationSamlFieldMapping]])
      def email: Output[Option[String]] = output.map(_.flatMap(_.email))
      def firstName: Output[Option[String]] = output.map(_.flatMap(_.firstName))
      def identity: Output[Option[String]] = output.map(_.flatMap(_.identity))
      def lastName: Output[Option[String]] = output.map(_.flatMap(_.lastName))
      def realName: Output[Option[String]] = output.map(_.flatMap(_.realName))


