package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class CassandraCassandraUserConfig private(
  additionalBackupRegions: Option[String],
  backupHour: Option[Int],
  backupMinute: Option[Int],
  cassandra: Option[besom.api.aiven.outputs.CassandraCassandraUserConfigCassandra],
  cassandraVersion: Option[String],
  ipFilterObjects: Option[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraCassandraUserConfigIpFilterObject]],
  ipFilterStrings: Option[scala.collection.immutable.List[String]],
  ipFilters: Option[scala.collection.immutable.List[String]],
  migrateSstableloader: Option[Boolean],
  privateAccess: Option[besom.api.aiven.outputs.CassandraCassandraUserConfigPrivateAccess],
  projectToForkFrom: Option[String],
  publicAccess: Option[besom.api.aiven.outputs.CassandraCassandraUserConfigPublicAccess],
  serviceToForkFrom: Option[String],
  serviceToJoinWith: Option[String],
  staticIps: Option[Boolean]
) derives Decoder

object CassandraCassandraUserConfig:
  given outputOps: {} with
    extension(output: Output[CassandraCassandraUserConfig])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.additionalBackupRegions)
      def backupHour: Output[Option[Int]] = output.map(_.backupHour)
      def backupMinute: Output[Option[Int]] = output.map(_.backupMinute)
      def cassandra: Output[Option[besom.api.aiven.outputs.CassandraCassandraUserConfigCassandra]] = output.map(_.cassandra)
      def cassandraVersion: Output[Option[String]] = output.map(_.cassandraVersion)
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraCassandraUserConfigIpFilterObject]]] = output.map(_.ipFilterObjects)
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilterStrings)
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilters)
      def migrateSstableloader: Output[Option[Boolean]] = output.map(_.migrateSstableloader)
      def privateAccess: Output[Option[besom.api.aiven.outputs.CassandraCassandraUserConfigPrivateAccess]] = output.map(_.privateAccess)
      def projectToForkFrom: Output[Option[String]] = output.map(_.projectToForkFrom)
      def publicAccess: Output[Option[besom.api.aiven.outputs.CassandraCassandraUserConfigPublicAccess]] = output.map(_.publicAccess)
      def serviceToForkFrom: Output[Option[String]] = output.map(_.serviceToForkFrom)
      def serviceToJoinWith: Output[Option[String]] = output.map(_.serviceToJoinWith)
      def staticIps: Output[Option[Boolean]] = output.map(_.staticIps)

  given optionOutputOps: {} with
    extension(output: Output[Option[CassandraCassandraUserConfig]])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.flatMap(_.additionalBackupRegions))
      def backupHour: Output[Option[Int]] = output.map(_.flatMap(_.backupHour))
      def backupMinute: Output[Option[Int]] = output.map(_.flatMap(_.backupMinute))
      def cassandra: Output[Option[besom.api.aiven.outputs.CassandraCassandraUserConfigCassandra]] = output.map(_.flatMap(_.cassandra))
      def cassandraVersion: Output[Option[String]] = output.map(_.flatMap(_.cassandraVersion))
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.CassandraCassandraUserConfigIpFilterObject]]] = output.map(_.flatMap(_.ipFilterObjects))
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilterStrings))
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilters))
      def migrateSstableloader: Output[Option[Boolean]] = output.map(_.flatMap(_.migrateSstableloader))
      def privateAccess: Output[Option[besom.api.aiven.outputs.CassandraCassandraUserConfigPrivateAccess]] = output.map(_.flatMap(_.privateAccess))
      def projectToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.projectToForkFrom))
      def publicAccess: Output[Option[besom.api.aiven.outputs.CassandraCassandraUserConfigPublicAccess]] = output.map(_.flatMap(_.publicAccess))
      def serviceToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.serviceToForkFrom))
      def serviceToJoinWith: Output[Option[String]] = output.map(_.flatMap(_.serviceToJoinWith))
      def staticIps: Output[Option[Boolean]] = output.map(_.flatMap(_.staticIps))


