package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ClickhouseGrantPrivilegeGrant private(
  column: Option[String],
  database: String,
  privilege: Option[String],
  table: Option[String],
  withGrant: Option[Boolean]
) derives Decoder

object ClickhouseGrantPrivilegeGrant:
  given outputOps: {} with
    extension(output: Output[ClickhouseGrantPrivilegeGrant])
      def column: Output[Option[String]] = output.map(_.column)
      def database: Output[String] = output.map(_.database)
      def privilege: Output[Option[String]] = output.map(_.privilege)
      def table: Output[Option[String]] = output.map(_.table)
      def withGrant: Output[Option[Boolean]] = output.map(_.withGrant)

  given optionOutputOps: {} with
    extension(output: Output[Option[ClickhouseGrantPrivilegeGrant]])
      def column: Output[Option[String]] = output.map(_.flatMap(_.column))
      def database: Output[Option[String]] = output.map(_.map(_.database))
      def privilege: Output[Option[String]] = output.map(_.flatMap(_.privilege))
      def table: Output[Option[String]] = output.map(_.flatMap(_.table))
      def withGrant: Output[Option[Boolean]] = output.map(_.flatMap(_.withGrant))


