package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class ClickhouseTag private(
  key: String,
  value: String
) derives Decoder

object ClickhouseTag:
  given outputOps: {} with
    extension(output: Output[ClickhouseTag])
      def key: Output[String] = output.map(_.key)
      def value: Output[String] = output.map(_.value)

  given optionOutputOps: {} with
    extension(output: Output[Option[ClickhouseTag]])
      def key: Output[Option[String]] = output.map(_.map(_.key))
      def value: Output[Option[String]] = output.map(_.map(_.value))


