package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class FlinkApplicationVersionSink private(
  createTable: String,
  integrationId: Option[String]
) derives Decoder

object FlinkApplicationVersionSink:
  given outputOps: {} with
    extension(output: Output[FlinkApplicationVersionSink])
      def createTable: Output[String] = output.map(_.createTable)
      def integrationId: Output[Option[String]] = output.map(_.integrationId)

  given optionOutputOps: {} with
    extension(output: Output[Option[FlinkApplicationVersionSink]])
      def createTable: Output[Option[String]] = output.map(_.map(_.createTable))
      def integrationId: Output[Option[String]] = output.map(_.flatMap(_.integrationId))


