package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class FlinkApplicationVersionSource private(
  createTable: String,
  integrationId: Option[String]
) derives Decoder

object FlinkApplicationVersionSource:
  given outputOps: {} with
    extension(output: Output[FlinkApplicationVersionSource])
      def createTable: Output[String] = output.map(_.createTable)
      def integrationId: Output[Option[String]] = output.map(_.integrationId)

  given optionOutputOps: {} with
    extension(output: Output[Option[FlinkApplicationVersionSource]])
      def createTable: Output[Option[String]] = output.map(_.map(_.createTable))
      def integrationId: Output[Option[String]] = output.map(_.flatMap(_.integrationId))


