package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetFlinkFlinkUserConfig private(
  flinkVersion: Option[String],
  ipFilterObjects: Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetFlinkFlinkUserConfigIpFilterObject]],
  ipFilterStrings: Option[scala.collection.immutable.List[String]],
  ipFilters: Option[scala.collection.immutable.List[String]],
  numberOfTaskSlots: Option[Int],
  privatelinkAccess: Option[besom.api.aiven.outputs.GetFlinkFlinkUserConfigPrivatelinkAccess]
) derives Decoder

object GetFlinkFlinkUserConfig:
  given outputOps: {} with
    extension(output: Output[GetFlinkFlinkUserConfig])
      def flinkVersion: Output[Option[String]] = output.map(_.flinkVersion)
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetFlinkFlinkUserConfigIpFilterObject]]] = output.map(_.ipFilterObjects)
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilterStrings)
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilters)
      def numberOfTaskSlots: Output[Option[Int]] = output.map(_.numberOfTaskSlots)
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.GetFlinkFlinkUserConfigPrivatelinkAccess]] = output.map(_.privatelinkAccess)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetFlinkFlinkUserConfig]])
      def flinkVersion: Output[Option[String]] = output.map(_.flatMap(_.flinkVersion))
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetFlinkFlinkUserConfigIpFilterObject]]] = output.map(_.flatMap(_.ipFilterObjects))
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilterStrings))
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilters))
      def numberOfTaskSlots: Output[Option[Int]] = output.map(_.flatMap(_.numberOfTaskSlots))
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.GetFlinkFlinkUserConfigPrivatelinkAccess]] = output.map(_.flatMap(_.privatelinkAccess))


