package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetGrafanaGrafanaUserConfig private(
  additionalBackupRegions: Option[String],
  alertingEnabled: Option[Boolean],
  alertingErrorOrTimeout: Option[String],
  alertingMaxAnnotationsToKeep: Option[Int],
  alertingNodataOrNullvalues: Option[String],
  allowEmbedding: Option[Boolean],
  authAzuread: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthAzuread],
  authBasicEnabled: Option[Boolean],
  authGenericOauth: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGenericOauth],
  authGithub: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGithub],
  authGitlab: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGitlab],
  authGoogle: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGoogle],
  cookieSamesite: Option[String],
  customDomain: Option[String],
  dashboardPreviewsEnabled: Option[Boolean],
  dashboardsMinRefreshInterval: Option[String],
  dashboardsVersionsToKeep: Option[Int],
  dataproxySendUserHeader: Option[Boolean],
  dataproxyTimeout: Option[Int],
  dateFormats: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigDateFormats],
  disableGravatar: Option[Boolean],
  editorsCanAdmin: Option[Boolean],
  externalImageStorage: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigExternalImageStorage],
  googleAnalyticsUaId: Option[String],
  ipFilterObjects: Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigIpFilterObject]],
  ipFilterStrings: Option[scala.collection.immutable.List[String]],
  ipFilters: Option[scala.collection.immutable.List[String]],
  metricsEnabled: Option[Boolean],
  oauthAllowInsecureEmailLookup: Option[Boolean],
  privateAccess: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPrivateAccess],
  privatelinkAccess: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPrivatelinkAccess],
  projectToForkFrom: Option[String],
  publicAccess: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPublicAccess],
  recoveryBasebackupName: Option[String],
  serviceToForkFrom: Option[String],
  smtpServer: Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigSmtpServer],
  staticIps: Option[Boolean],
  userAutoAssignOrg: Option[Boolean],
  userAutoAssignOrgRole: Option[String],
  viewersCanEdit: Option[Boolean]
) derives Decoder

object GetGrafanaGrafanaUserConfig:
  given outputOps: {} with
    extension(output: Output[GetGrafanaGrafanaUserConfig])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.additionalBackupRegions)
      def alertingEnabled: Output[Option[Boolean]] = output.map(_.alertingEnabled)
      def alertingErrorOrTimeout: Output[Option[String]] = output.map(_.alertingErrorOrTimeout)
      def alertingMaxAnnotationsToKeep: Output[Option[Int]] = output.map(_.alertingMaxAnnotationsToKeep)
      def alertingNodataOrNullvalues: Output[Option[String]] = output.map(_.alertingNodataOrNullvalues)
      def allowEmbedding: Output[Option[Boolean]] = output.map(_.allowEmbedding)
      def authAzuread: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthAzuread]] = output.map(_.authAzuread)
      def authBasicEnabled: Output[Option[Boolean]] = output.map(_.authBasicEnabled)
      def authGenericOauth: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGenericOauth]] = output.map(_.authGenericOauth)
      def authGithub: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGithub]] = output.map(_.authGithub)
      def authGitlab: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGitlab]] = output.map(_.authGitlab)
      def authGoogle: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGoogle]] = output.map(_.authGoogle)
      def cookieSamesite: Output[Option[String]] = output.map(_.cookieSamesite)
      def customDomain: Output[Option[String]] = output.map(_.customDomain)
      def dashboardPreviewsEnabled: Output[Option[Boolean]] = output.map(_.dashboardPreviewsEnabled)
      def dashboardsMinRefreshInterval: Output[Option[String]] = output.map(_.dashboardsMinRefreshInterval)
      def dashboardsVersionsToKeep: Output[Option[Int]] = output.map(_.dashboardsVersionsToKeep)
      def dataproxySendUserHeader: Output[Option[Boolean]] = output.map(_.dataproxySendUserHeader)
      def dataproxyTimeout: Output[Option[Int]] = output.map(_.dataproxyTimeout)
      def dateFormats: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigDateFormats]] = output.map(_.dateFormats)
      def disableGravatar: Output[Option[Boolean]] = output.map(_.disableGravatar)
      def editorsCanAdmin: Output[Option[Boolean]] = output.map(_.editorsCanAdmin)
      def externalImageStorage: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigExternalImageStorage]] = output.map(_.externalImageStorage)
      def googleAnalyticsUaId: Output[Option[String]] = output.map(_.googleAnalyticsUaId)
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigIpFilterObject]]] = output.map(_.ipFilterObjects)
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilterStrings)
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilters)
      def metricsEnabled: Output[Option[Boolean]] = output.map(_.metricsEnabled)
      def oauthAllowInsecureEmailLookup: Output[Option[Boolean]] = output.map(_.oauthAllowInsecureEmailLookup)
      def privateAccess: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPrivateAccess]] = output.map(_.privateAccess)
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPrivatelinkAccess]] = output.map(_.privatelinkAccess)
      def projectToForkFrom: Output[Option[String]] = output.map(_.projectToForkFrom)
      def publicAccess: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPublicAccess]] = output.map(_.publicAccess)
      def recoveryBasebackupName: Output[Option[String]] = output.map(_.recoveryBasebackupName)
      def serviceToForkFrom: Output[Option[String]] = output.map(_.serviceToForkFrom)
      def smtpServer: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigSmtpServer]] = output.map(_.smtpServer)
      def staticIps: Output[Option[Boolean]] = output.map(_.staticIps)
      def userAutoAssignOrg: Output[Option[Boolean]] = output.map(_.userAutoAssignOrg)
      def userAutoAssignOrgRole: Output[Option[String]] = output.map(_.userAutoAssignOrgRole)
      def viewersCanEdit: Output[Option[Boolean]] = output.map(_.viewersCanEdit)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetGrafanaGrafanaUserConfig]])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.flatMap(_.additionalBackupRegions))
      def alertingEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.alertingEnabled))
      def alertingErrorOrTimeout: Output[Option[String]] = output.map(_.flatMap(_.alertingErrorOrTimeout))
      def alertingMaxAnnotationsToKeep: Output[Option[Int]] = output.map(_.flatMap(_.alertingMaxAnnotationsToKeep))
      def alertingNodataOrNullvalues: Output[Option[String]] = output.map(_.flatMap(_.alertingNodataOrNullvalues))
      def allowEmbedding: Output[Option[Boolean]] = output.map(_.flatMap(_.allowEmbedding))
      def authAzuread: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthAzuread]] = output.map(_.flatMap(_.authAzuread))
      def authBasicEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.authBasicEnabled))
      def authGenericOauth: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGenericOauth]] = output.map(_.flatMap(_.authGenericOauth))
      def authGithub: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGithub]] = output.map(_.flatMap(_.authGithub))
      def authGitlab: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGitlab]] = output.map(_.flatMap(_.authGitlab))
      def authGoogle: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigAuthGoogle]] = output.map(_.flatMap(_.authGoogle))
      def cookieSamesite: Output[Option[String]] = output.map(_.flatMap(_.cookieSamesite))
      def customDomain: Output[Option[String]] = output.map(_.flatMap(_.customDomain))
      def dashboardPreviewsEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.dashboardPreviewsEnabled))
      def dashboardsMinRefreshInterval: Output[Option[String]] = output.map(_.flatMap(_.dashboardsMinRefreshInterval))
      def dashboardsVersionsToKeep: Output[Option[Int]] = output.map(_.flatMap(_.dashboardsVersionsToKeep))
      def dataproxySendUserHeader: Output[Option[Boolean]] = output.map(_.flatMap(_.dataproxySendUserHeader))
      def dataproxyTimeout: Output[Option[Int]] = output.map(_.flatMap(_.dataproxyTimeout))
      def dateFormats: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigDateFormats]] = output.map(_.flatMap(_.dateFormats))
      def disableGravatar: Output[Option[Boolean]] = output.map(_.flatMap(_.disableGravatar))
      def editorsCanAdmin: Output[Option[Boolean]] = output.map(_.flatMap(_.editorsCanAdmin))
      def externalImageStorage: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigExternalImageStorage]] = output.map(_.flatMap(_.externalImageStorage))
      def googleAnalyticsUaId: Output[Option[String]] = output.map(_.flatMap(_.googleAnalyticsUaId))
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigIpFilterObject]]] = output.map(_.flatMap(_.ipFilterObjects))
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilterStrings))
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilters))
      def metricsEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.metricsEnabled))
      def oauthAllowInsecureEmailLookup: Output[Option[Boolean]] = output.map(_.flatMap(_.oauthAllowInsecureEmailLookup))
      def privateAccess: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPrivateAccess]] = output.map(_.flatMap(_.privateAccess))
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPrivatelinkAccess]] = output.map(_.flatMap(_.privatelinkAccess))
      def projectToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.projectToForkFrom))
      def publicAccess: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigPublicAccess]] = output.map(_.flatMap(_.publicAccess))
      def recoveryBasebackupName: Output[Option[String]] = output.map(_.flatMap(_.recoveryBasebackupName))
      def serviceToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.serviceToForkFrom))
      def smtpServer: Output[Option[besom.api.aiven.outputs.GetGrafanaGrafanaUserConfigSmtpServer]] = output.map(_.flatMap(_.smtpServer))
      def staticIps: Output[Option[Boolean]] = output.map(_.flatMap(_.staticIps))
      def userAutoAssignOrg: Output[Option[Boolean]] = output.map(_.flatMap(_.userAutoAssignOrg))
      def userAutoAssignOrgRole: Output[Option[String]] = output.map(_.flatMap(_.userAutoAssignOrgRole))
      def viewersCanEdit: Output[Option[Boolean]] = output.map(_.flatMap(_.viewersCanEdit))


