package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetGrafanaGrafanaUserConfigAuthAzuread private(
  allowSignUp: Option[Boolean],
  allowedDomains: Option[scala.collection.immutable.List[String]],
  allowedGroups: Option[scala.collection.immutable.List[String]],
  authUrl: String,
  clientId: String,
  clientSecret: String,
  tokenUrl: String
) derives Decoder

object GetGrafanaGrafanaUserConfigAuthAzuread:
  given outputOps: {} with
    extension(output: Output[GetGrafanaGrafanaUserConfigAuthAzuread])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.allowSignUp)
      def allowedDomains: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.allowedDomains)
      def allowedGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.allowedGroups)
      def authUrl: Output[String] = output.map(_.authUrl)
      def clientId: Output[String] = output.map(_.clientId)
      def clientSecret: Output[String] = output.map(_.clientSecret)
      def tokenUrl: Output[String] = output.map(_.tokenUrl)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetGrafanaGrafanaUserConfigAuthAzuread]])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.flatMap(_.allowSignUp))
      def allowedDomains: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.allowedDomains))
      def allowedGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.allowedGroups))
      def authUrl: Output[Option[String]] = output.map(_.map(_.authUrl))
      def clientId: Output[Option[String]] = output.map(_.map(_.clientId))
      def clientSecret: Output[Option[String]] = output.map(_.map(_.clientSecret))
      def tokenUrl: Output[Option[String]] = output.map(_.map(_.tokenUrl))


