package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetGrafanaGrafanaUserConfigAuthGenericOauth private(
  allowSignUp: Option[Boolean],
  allowedDomains: Option[scala.collection.immutable.List[String]],
  allowedOrganizations: Option[scala.collection.immutable.List[String]],
  apiUrl: String,
  authUrl: String,
  autoLogin: Option[Boolean],
  clientId: String,
  clientSecret: String,
  name: Option[String],
  scopes: Option[scala.collection.immutable.List[String]],
  tokenUrl: String
) derives Decoder

object GetGrafanaGrafanaUserConfigAuthGenericOauth:
  given outputOps: {} with
    extension(output: Output[GetGrafanaGrafanaUserConfigAuthGenericOauth])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.allowSignUp)
      def allowedDomains: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.allowedDomains)
      def allowedOrganizations: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.allowedOrganizations)
      def apiUrl: Output[String] = output.map(_.apiUrl)
      def authUrl: Output[String] = output.map(_.authUrl)
      def autoLogin: Output[Option[Boolean]] = output.map(_.autoLogin)
      def clientId: Output[String] = output.map(_.clientId)
      def clientSecret: Output[String] = output.map(_.clientSecret)
      def name: Output[Option[String]] = output.map(_.name)
      def scopes: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.scopes)
      def tokenUrl: Output[String] = output.map(_.tokenUrl)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetGrafanaGrafanaUserConfigAuthGenericOauth]])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.flatMap(_.allowSignUp))
      def allowedDomains: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.allowedDomains))
      def allowedOrganizations: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.allowedOrganizations))
      def apiUrl: Output[Option[String]] = output.map(_.map(_.apiUrl))
      def authUrl: Output[Option[String]] = output.map(_.map(_.authUrl))
      def autoLogin: Output[Option[Boolean]] = output.map(_.flatMap(_.autoLogin))
      def clientId: Output[Option[String]] = output.map(_.map(_.clientId))
      def clientSecret: Output[Option[String]] = output.map(_.map(_.clientSecret))
      def name: Output[Option[String]] = output.map(_.flatMap(_.name))
      def scopes: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.scopes))
      def tokenUrl: Output[Option[String]] = output.map(_.map(_.tokenUrl))


