package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetGrafanaGrafanaUserConfigAuthGitlab private(
  allowSignUp: Option[Boolean],
  allowedGroups: Option[scala.collection.immutable.List[String]],
  apiUrl: Option[String],
  authUrl: Option[String],
  clientId: String,
  clientSecret: String,
  tokenUrl: Option[String]
) derives Decoder

object GetGrafanaGrafanaUserConfigAuthGitlab:
  given outputOps: {} with
    extension(output: Output[GetGrafanaGrafanaUserConfigAuthGitlab])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.allowSignUp)
      def allowedGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.allowedGroups)
      def apiUrl: Output[Option[String]] = output.map(_.apiUrl)
      def authUrl: Output[Option[String]] = output.map(_.authUrl)
      def clientId: Output[String] = output.map(_.clientId)
      def clientSecret: Output[String] = output.map(_.clientSecret)
      def tokenUrl: Output[Option[String]] = output.map(_.tokenUrl)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetGrafanaGrafanaUserConfigAuthGitlab]])
      def allowSignUp: Output[Option[Boolean]] = output.map(_.flatMap(_.allowSignUp))
      def allowedGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.allowedGroups))
      def apiUrl: Output[Option[String]] = output.map(_.flatMap(_.apiUrl))
      def authUrl: Output[Option[String]] = output.map(_.flatMap(_.authUrl))
      def clientId: Output[Option[String]] = output.map(_.map(_.clientId))
      def clientSecret: Output[Option[String]] = output.map(_.map(_.clientSecret))
      def tokenUrl: Output[Option[String]] = output.map(_.flatMap(_.tokenUrl))


