package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetGrafanaGrafanaUserConfigSmtpServer private(
  fromAddress: String,
  fromName: Option[String],
  host: String,
  password: Option[String],
  port: Int,
  skipVerify: Option[Boolean],
  starttlsPolicy: Option[String],
  username: Option[String]
) derives Decoder

object GetGrafanaGrafanaUserConfigSmtpServer:
  given outputOps: {} with
    extension(output: Output[GetGrafanaGrafanaUserConfigSmtpServer])
      def fromAddress: Output[String] = output.map(_.fromAddress)
      def fromName: Output[Option[String]] = output.map(_.fromName)
      def host: Output[String] = output.map(_.host)
      def password: Output[Option[String]] = output.map(_.password)
      def port: Output[Int] = output.map(_.port)
      def skipVerify: Output[Option[Boolean]] = output.map(_.skipVerify)
      def starttlsPolicy: Output[Option[String]] = output.map(_.starttlsPolicy)
      def username: Output[Option[String]] = output.map(_.username)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetGrafanaGrafanaUserConfigSmtpServer]])
      def fromAddress: Output[Option[String]] = output.map(_.map(_.fromAddress))
      def fromName: Output[Option[String]] = output.map(_.flatMap(_.fromName))
      def host: Output[Option[String]] = output.map(_.map(_.host))
      def password: Output[Option[String]] = output.map(_.flatMap(_.password))
      def port: Output[Option[Int]] = output.map(_.map(_.port))
      def skipVerify: Output[Option[Boolean]] = output.map(_.flatMap(_.skipVerify))
      def starttlsPolicy: Output[Option[String]] = output.map(_.flatMap(_.starttlsPolicy))
      def username: Output[Option[String]] = output.map(_.flatMap(_.username))


