package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetInfluxDbTag private(
  key: String,
  value: String
) derives Decoder

object GetInfluxDbTag:
  given outputOps: {} with
    extension(output: Output[GetInfluxDbTag])
      def key: Output[String] = output.map(_.key)
      def value: Output[String] = output.map(_.value)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetInfluxDbTag]])
      def key: Output[Option[String]] = output.map(_.map(_.key))
      def value: Output[Option[String]] = output.map(_.map(_.value))


