package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetKafkaConnectComponent private(
  component: String,
  host: String,
  kafkaAuthenticationMethod: String,
  port: Int,
  route: String,
  ssl: Boolean,
  usage: String
) derives Decoder

object GetKafkaConnectComponent:
  given outputOps: {} with
    extension(output: Output[GetKafkaConnectComponent])
      def component: Output[String] = output.map(_.component)
      def host: Output[String] = output.map(_.host)
      def kafkaAuthenticationMethod: Output[String] = output.map(_.kafkaAuthenticationMethod)
      def port: Output[Int] = output.map(_.port)
      def route: Output[String] = output.map(_.route)
      def ssl: Output[Boolean] = output.map(_.ssl)
      def usage: Output[String] = output.map(_.usage)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetKafkaConnectComponent]])
      def component: Output[Option[String]] = output.map(_.map(_.component))
      def host: Output[Option[String]] = output.map(_.map(_.host))
      def kafkaAuthenticationMethod: Output[Option[String]] = output.map(_.map(_.kafkaAuthenticationMethod))
      def port: Output[Option[Int]] = output.map(_.map(_.port))
      def route: Output[Option[String]] = output.map(_.map(_.route))
      def ssl: Output[Option[Boolean]] = output.map(_.map(_.ssl))
      def usage: Output[Option[String]] = output.map(_.map(_.usage))


