package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetKafkaConnectorTask private(
  connector: String,
  task: Int
) derives Decoder

object GetKafkaConnectorTask:
  given outputOps: {} with
    extension(output: Output[GetKafkaConnectorTask])
      def connector: Output[String] = output.map(_.connector)
      def task: Output[Int] = output.map(_.task)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetKafkaConnectorTask]])
      def connector: Output[Option[String]] = output.map(_.map(_.connector))
      def task: Output[Option[Int]] = output.map(_.map(_.task))


