package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetKafkaKafka private(
  accessCert: String,
  accessKey: String,
  connectUri: String,
  restUri: String,
  schemaRegistryUri: String
) derives Decoder

object GetKafkaKafka:
  given outputOps: {} with
    extension(output: Output[GetKafkaKafka])
      def accessCert: Output[String] = output.map(_.accessCert)
      def accessKey: Output[String] = output.map(_.accessKey)
      def connectUri: Output[String] = output.map(_.connectUri)
      def restUri: Output[String] = output.map(_.restUri)
      def schemaRegistryUri: Output[String] = output.map(_.schemaRegistryUri)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetKafkaKafka]])
      def accessCert: Output[Option[String]] = output.map(_.map(_.accessCert))
      def accessKey: Output[Option[String]] = output.map(_.map(_.accessKey))
      def connectUri: Output[Option[String]] = output.map(_.map(_.connectUri))
      def restUri: Output[Option[String]] = output.map(_.map(_.restUri))
      def schemaRegistryUri: Output[Option[String]] = output.map(_.map(_.schemaRegistryUri))


