package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetKafkaKafkaUserConfigKafkaRestConfig private(
  consumerEnableAutoCommit: Option[Boolean],
  consumerRequestMaxBytes: Option[Int],
  consumerRequestTimeoutMs: Option[Int],
  producerAcks: Option[String],
  producerCompressionType: Option[String],
  producerLingerMs: Option[Int],
  producerMaxRequestSize: Option[Int],
  simpleconsumerPoolSizeMax: Option[Int]
) derives Decoder

object GetKafkaKafkaUserConfigKafkaRestConfig:
  given outputOps: {} with
    extension(output: Output[GetKafkaKafkaUserConfigKafkaRestConfig])
      def consumerEnableAutoCommit: Output[Option[Boolean]] = output.map(_.consumerEnableAutoCommit)
      def consumerRequestMaxBytes: Output[Option[Int]] = output.map(_.consumerRequestMaxBytes)
      def consumerRequestTimeoutMs: Output[Option[Int]] = output.map(_.consumerRequestTimeoutMs)
      def producerAcks: Output[Option[String]] = output.map(_.producerAcks)
      def producerCompressionType: Output[Option[String]] = output.map(_.producerCompressionType)
      def producerLingerMs: Output[Option[Int]] = output.map(_.producerLingerMs)
      def producerMaxRequestSize: Output[Option[Int]] = output.map(_.producerMaxRequestSize)
      def simpleconsumerPoolSizeMax: Output[Option[Int]] = output.map(_.simpleconsumerPoolSizeMax)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetKafkaKafkaUserConfigKafkaRestConfig]])
      def consumerEnableAutoCommit: Output[Option[Boolean]] = output.map(_.flatMap(_.consumerEnableAutoCommit))
      def consumerRequestMaxBytes: Output[Option[Int]] = output.map(_.flatMap(_.consumerRequestMaxBytes))
      def consumerRequestTimeoutMs: Output[Option[Int]] = output.map(_.flatMap(_.consumerRequestTimeoutMs))
      def producerAcks: Output[Option[String]] = output.map(_.flatMap(_.producerAcks))
      def producerCompressionType: Output[Option[String]] = output.map(_.flatMap(_.producerCompressionType))
      def producerLingerMs: Output[Option[Int]] = output.map(_.flatMap(_.producerLingerMs))
      def producerMaxRequestSize: Output[Option[Int]] = output.map(_.flatMap(_.producerMaxRequestSize))
      def simpleconsumerPoolSizeMax: Output[Option[Int]] = output.map(_.flatMap(_.simpleconsumerPoolSizeMax))


