package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetKafkaTopicConfig private(
  cleanupPolicy: Option[String],
  compressionType: Option[String],
  deleteRetentionMs: Option[String],
  fileDeleteDelayMs: Option[String],
  flushMessages: Option[String],
  flushMs: Option[String],
  indexIntervalBytes: Option[String],
  maxCompactionLagMs: Option[String],
  maxMessageBytes: Option[String],
  messageDownconversionEnable: Option[Boolean],
  messageFormatVersion: Option[String],
  messageTimestampDifferenceMaxMs: Option[String],
  messageTimestampType: Option[String],
  minCleanableDirtyRatio: Option[Double],
  minCompactionLagMs: Option[String],
  minInsyncReplicas: Option[String],
  preallocate: Option[Boolean],
  retentionBytes: Option[String],
  retentionMs: Option[String],
  segmentBytes: Option[String],
  segmentIndexBytes: Option[String],
  segmentJitterMs: Option[String],
  segmentMs: Option[String],
  uncleanLeaderElectionEnable: Option[Boolean]
) derives Decoder

object GetKafkaTopicConfig:
  given outputOps: {} with
    extension(output: Output[GetKafkaTopicConfig])
      def cleanupPolicy: Output[Option[String]] = output.map(_.cleanupPolicy)
      def compressionType: Output[Option[String]] = output.map(_.compressionType)
      def deleteRetentionMs: Output[Option[String]] = output.map(_.deleteRetentionMs)
      def fileDeleteDelayMs: Output[Option[String]] = output.map(_.fileDeleteDelayMs)
      def flushMessages: Output[Option[String]] = output.map(_.flushMessages)
      def flushMs: Output[Option[String]] = output.map(_.flushMs)
      def indexIntervalBytes: Output[Option[String]] = output.map(_.indexIntervalBytes)
      def maxCompactionLagMs: Output[Option[String]] = output.map(_.maxCompactionLagMs)
      def maxMessageBytes: Output[Option[String]] = output.map(_.maxMessageBytes)
      def messageDownconversionEnable: Output[Option[Boolean]] = output.map(_.messageDownconversionEnable)
      def messageFormatVersion: Output[Option[String]] = output.map(_.messageFormatVersion)
      def messageTimestampDifferenceMaxMs: Output[Option[String]] = output.map(_.messageTimestampDifferenceMaxMs)
      def messageTimestampType: Output[Option[String]] = output.map(_.messageTimestampType)
      def minCleanableDirtyRatio: Output[Option[Double]] = output.map(_.minCleanableDirtyRatio)
      def minCompactionLagMs: Output[Option[String]] = output.map(_.minCompactionLagMs)
      def minInsyncReplicas: Output[Option[String]] = output.map(_.minInsyncReplicas)
      def preallocate: Output[Option[Boolean]] = output.map(_.preallocate)
      def retentionBytes: Output[Option[String]] = output.map(_.retentionBytes)
      def retentionMs: Output[Option[String]] = output.map(_.retentionMs)
      def segmentBytes: Output[Option[String]] = output.map(_.segmentBytes)
      def segmentIndexBytes: Output[Option[String]] = output.map(_.segmentIndexBytes)
      def segmentJitterMs: Output[Option[String]] = output.map(_.segmentJitterMs)
      def segmentMs: Output[Option[String]] = output.map(_.segmentMs)
      def uncleanLeaderElectionEnable: Output[Option[Boolean]] = output.map(_.uncleanLeaderElectionEnable)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetKafkaTopicConfig]])
      def cleanupPolicy: Output[Option[String]] = output.map(_.flatMap(_.cleanupPolicy))
      def compressionType: Output[Option[String]] = output.map(_.flatMap(_.compressionType))
      def deleteRetentionMs: Output[Option[String]] = output.map(_.flatMap(_.deleteRetentionMs))
      def fileDeleteDelayMs: Output[Option[String]] = output.map(_.flatMap(_.fileDeleteDelayMs))
      def flushMessages: Output[Option[String]] = output.map(_.flatMap(_.flushMessages))
      def flushMs: Output[Option[String]] = output.map(_.flatMap(_.flushMs))
      def indexIntervalBytes: Output[Option[String]] = output.map(_.flatMap(_.indexIntervalBytes))
      def maxCompactionLagMs: Output[Option[String]] = output.map(_.flatMap(_.maxCompactionLagMs))
      def maxMessageBytes: Output[Option[String]] = output.map(_.flatMap(_.maxMessageBytes))
      def messageDownconversionEnable: Output[Option[Boolean]] = output.map(_.flatMap(_.messageDownconversionEnable))
      def messageFormatVersion: Output[Option[String]] = output.map(_.flatMap(_.messageFormatVersion))
      def messageTimestampDifferenceMaxMs: Output[Option[String]] = output.map(_.flatMap(_.messageTimestampDifferenceMaxMs))
      def messageTimestampType: Output[Option[String]] = output.map(_.flatMap(_.messageTimestampType))
      def minCleanableDirtyRatio: Output[Option[Double]] = output.map(_.flatMap(_.minCleanableDirtyRatio))
      def minCompactionLagMs: Output[Option[String]] = output.map(_.flatMap(_.minCompactionLagMs))
      def minInsyncReplicas: Output[Option[String]] = output.map(_.flatMap(_.minInsyncReplicas))
      def preallocate: Output[Option[Boolean]] = output.map(_.flatMap(_.preallocate))
      def retentionBytes: Output[Option[String]] = output.map(_.flatMap(_.retentionBytes))
      def retentionMs: Output[Option[String]] = output.map(_.flatMap(_.retentionMs))
      def segmentBytes: Output[Option[String]] = output.map(_.flatMap(_.segmentBytes))
      def segmentIndexBytes: Output[Option[String]] = output.map(_.flatMap(_.segmentIndexBytes))
      def segmentJitterMs: Output[Option[String]] = output.map(_.flatMap(_.segmentJitterMs))
      def segmentMs: Output[Option[String]] = output.map(_.flatMap(_.segmentMs))
      def uncleanLeaderElectionEnable: Output[Option[Boolean]] = output.map(_.flatMap(_.uncleanLeaderElectionEnable))


