package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetKafkaTopicTag private(
  key: String,
  value: Option[String]
) derives Decoder

object GetKafkaTopicTag:
  given outputOps: {} with
    extension(output: Output[GetKafkaTopicTag])
      def key: Output[String] = output.map(_.key)
      def value: Output[Option[String]] = output.map(_.value)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetKafkaTopicTag]])
      def key: Output[Option[String]] = output.map(_.map(_.key))
      def value: Output[Option[String]] = output.map(_.flatMap(_.value))


