package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetM3AggregatorServiceIntegration private(
  integrationType: String,
  sourceServiceName: String
) derives Decoder

object GetM3AggregatorServiceIntegration:
  given outputOps: {} with
    extension(output: Output[GetM3AggregatorServiceIntegration])
      def integrationType: Output[String] = output.map(_.integrationType)
      def sourceServiceName: Output[String] = output.map(_.sourceServiceName)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetM3AggregatorServiceIntegration]])
      def integrationType: Output[Option[String]] = output.map(_.map(_.integrationType))
      def sourceServiceName: Output[Option[String]] = output.map(_.map(_.sourceServiceName))


