package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetMySqlMysqlUserConfigPublicAccess private(
  mysql: Option[Boolean],
  mysqlx: Option[Boolean],
  prometheus: Option[Boolean]
) derives Decoder

object GetMySqlMysqlUserConfigPublicAccess:
  given outputOps: {} with
    extension(output: Output[GetMySqlMysqlUserConfigPublicAccess])
      def mysql: Output[Option[Boolean]] = output.map(_.mysql)
      def mysqlx: Output[Option[Boolean]] = output.map(_.mysqlx)
      def prometheus: Output[Option[Boolean]] = output.map(_.prometheus)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetMySqlMysqlUserConfigPublicAccess]])
      def mysql: Output[Option[Boolean]] = output.map(_.flatMap(_.mysql))
      def mysqlx: Output[Option[Boolean]] = output.map(_.flatMap(_.mysqlx))
      def prometheus: Output[Option[Boolean]] = output.map(_.flatMap(_.prometheus))


