package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetOpenSearchOpensearchUserConfigPrivatelinkAccess private(
  opensearch: Option[Boolean],
  opensearchDashboards: Option[Boolean],
  prometheus: Option[Boolean]
) derives Decoder

object GetOpenSearchOpensearchUserConfigPrivatelinkAccess:
  given outputOps: {} with
    extension(output: Output[GetOpenSearchOpensearchUserConfigPrivatelinkAccess])
      def opensearch: Output[Option[Boolean]] = output.map(_.opensearch)
      def opensearchDashboards: Output[Option[Boolean]] = output.map(_.opensearchDashboards)
      def prometheus: Output[Option[Boolean]] = output.map(_.prometheus)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetOpenSearchOpensearchUserConfigPrivatelinkAccess]])
      def opensearch: Output[Option[Boolean]] = output.map(_.flatMap(_.opensearch))
      def opensearchDashboards: Output[Option[Boolean]] = output.map(_.flatMap(_.opensearchDashboards))
      def prometheus: Output[Option[Boolean]] = output.map(_.flatMap(_.prometheus))


