package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetOpenSearchOpensearchUserConfigSaml private(
  enabled: Boolean,
  idpEntityId: String,
  idpMetadataUrl: String,
  idpPemtrustedcasContent: Option[String],
  rolesKey: Option[String],
  spEntityId: String,
  subjectKey: Option[String]
) derives Decoder

object GetOpenSearchOpensearchUserConfigSaml:
  given outputOps: {} with
    extension(output: Output[GetOpenSearchOpensearchUserConfigSaml])
      def enabled: Output[Boolean] = output.map(_.enabled)
      def idpEntityId: Output[String] = output.map(_.idpEntityId)
      def idpMetadataUrl: Output[String] = output.map(_.idpMetadataUrl)
      def idpPemtrustedcasContent: Output[Option[String]] = output.map(_.idpPemtrustedcasContent)
      def rolesKey: Output[Option[String]] = output.map(_.rolesKey)
      def spEntityId: Output[String] = output.map(_.spEntityId)
      def subjectKey: Output[Option[String]] = output.map(_.subjectKey)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetOpenSearchOpensearchUserConfigSaml]])
      def enabled: Output[Option[Boolean]] = output.map(_.map(_.enabled))
      def idpEntityId: Output[Option[String]] = output.map(_.map(_.idpEntityId))
      def idpMetadataUrl: Output[Option[String]] = output.map(_.map(_.idpMetadataUrl))
      def idpPemtrustedcasContent: Output[Option[String]] = output.map(_.flatMap(_.idpPemtrustedcasContent))
      def rolesKey: Output[Option[String]] = output.map(_.flatMap(_.rolesKey))
      def spEntityId: Output[Option[String]] = output.map(_.map(_.spEntityId))
      def subjectKey: Output[Option[String]] = output.map(_.flatMap(_.subjectKey))


