package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPgPg private(
  dbname: String,
  host: String,
  maxConnections: Int,
  password: String,
  port: Int,
  replicaUri: String,
  sslmode: String,
  uri: String,
  user: String
) derives Decoder

object GetPgPg:
  given outputOps: {} with
    extension(output: Output[GetPgPg])
      def dbname: Output[String] = output.map(_.dbname)
      def host: Output[String] = output.map(_.host)
      def maxConnections: Output[Int] = output.map(_.maxConnections)
      def password: Output[String] = output.map(_.password)
      def port: Output[Int] = output.map(_.port)
      def replicaUri: Output[String] = output.map(_.replicaUri)
      def sslmode: Output[String] = output.map(_.sslmode)
      def uri: Output[String] = output.map(_.uri)
      def user: Output[String] = output.map(_.user)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPgPg]])
      def dbname: Output[Option[String]] = output.map(_.map(_.dbname))
      def host: Output[Option[String]] = output.map(_.map(_.host))
      def maxConnections: Output[Option[Int]] = output.map(_.map(_.maxConnections))
      def password: Output[Option[String]] = output.map(_.map(_.password))
      def port: Output[Option[Int]] = output.map(_.map(_.port))
      def replicaUri: Output[Option[String]] = output.map(_.map(_.replicaUri))
      def sslmode: Output[Option[String]] = output.map(_.map(_.sslmode))
      def uri: Output[Option[String]] = output.map(_.map(_.uri))
      def user: Output[Option[String]] = output.map(_.map(_.user))


