package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPgPgUserConfigPg private(
  autovacuumAnalyzeScaleFactor: Option[Double],
  autovacuumAnalyzeThreshold: Option[Int],
  autovacuumFreezeMaxAge: Option[Int],
  autovacuumMaxWorkers: Option[Int],
  autovacuumNaptime: Option[Int],
  autovacuumVacuumCostDelay: Option[Int],
  autovacuumVacuumCostLimit: Option[Int],
  autovacuumVacuumScaleFactor: Option[Double],
  autovacuumVacuumThreshold: Option[Int],
  bgwriterDelay: Option[Int],
  bgwriterFlushAfter: Option[Int],
  bgwriterLruMaxpages: Option[Int],
  bgwriterLruMultiplier: Option[Double],
  deadlockTimeout: Option[Int],
  defaultToastCompression: Option[String],
  idleInTransactionSessionTimeout: Option[Int],
  jit: Option[Boolean],
  logAutovacuumMinDuration: Option[Int],
  logErrorVerbosity: Option[String],
  logLinePrefix: Option[String],
  logMinDurationStatement: Option[Int],
  logTempFiles: Option[Int],
  maxFilesPerProcess: Option[Int],
  maxLocksPerTransaction: Option[Int],
  maxLogicalReplicationWorkers: Option[Int],
  maxParallelWorkers: Option[Int],
  maxParallelWorkersPerGather: Option[Int],
  maxPredLocksPerTransaction: Option[Int],
  maxPreparedTransactions: Option[Int],
  maxReplicationSlots: Option[Int],
  maxSlotWalKeepSize: Option[Int],
  maxStackDepth: Option[Int],
  maxStandbyArchiveDelay: Option[Int],
  maxStandbyStreamingDelay: Option[Int],
  maxWalSenders: Option[Int],
  maxWorkerProcesses: Option[Int],
  pgPartmanBgwDotInterval: Option[Int],
  pgPartmanBgwDotRole: Option[String],
  pgStatMonitorDotPgsmEnableQueryPlan: Option[Boolean],
  pgStatMonitorDotPgsmMaxBuckets: Option[Int],
  pgStatStatementsDotTrack: Option[String],
  tempFileLimit: Option[Int],
  timezone: Option[String],
  trackActivityQuerySize: Option[Int],
  trackCommitTimestamp: Option[String],
  trackFunctions: Option[String],
  trackIoTiming: Option[String],
  walSenderTimeout: Option[Int],
  walWriterDelay: Option[Int]
) derives Decoder

object GetPgPgUserConfigPg:
  given outputOps: {} with
    extension(output: Output[GetPgPgUserConfigPg])
      def autovacuumAnalyzeScaleFactor: Output[Option[Double]] = output.map(_.autovacuumAnalyzeScaleFactor)
      def autovacuumAnalyzeThreshold: Output[Option[Int]] = output.map(_.autovacuumAnalyzeThreshold)
      def autovacuumFreezeMaxAge: Output[Option[Int]] = output.map(_.autovacuumFreezeMaxAge)
      def autovacuumMaxWorkers: Output[Option[Int]] = output.map(_.autovacuumMaxWorkers)
      def autovacuumNaptime: Output[Option[Int]] = output.map(_.autovacuumNaptime)
      def autovacuumVacuumCostDelay: Output[Option[Int]] = output.map(_.autovacuumVacuumCostDelay)
      def autovacuumVacuumCostLimit: Output[Option[Int]] = output.map(_.autovacuumVacuumCostLimit)
      def autovacuumVacuumScaleFactor: Output[Option[Double]] = output.map(_.autovacuumVacuumScaleFactor)
      def autovacuumVacuumThreshold: Output[Option[Int]] = output.map(_.autovacuumVacuumThreshold)
      def bgwriterDelay: Output[Option[Int]] = output.map(_.bgwriterDelay)
      def bgwriterFlushAfter: Output[Option[Int]] = output.map(_.bgwriterFlushAfter)
      def bgwriterLruMaxpages: Output[Option[Int]] = output.map(_.bgwriterLruMaxpages)
      def bgwriterLruMultiplier: Output[Option[Double]] = output.map(_.bgwriterLruMultiplier)
      def deadlockTimeout: Output[Option[Int]] = output.map(_.deadlockTimeout)
      def defaultToastCompression: Output[Option[String]] = output.map(_.defaultToastCompression)
      def idleInTransactionSessionTimeout: Output[Option[Int]] = output.map(_.idleInTransactionSessionTimeout)
      def jit: Output[Option[Boolean]] = output.map(_.jit)
      def logAutovacuumMinDuration: Output[Option[Int]] = output.map(_.logAutovacuumMinDuration)
      def logErrorVerbosity: Output[Option[String]] = output.map(_.logErrorVerbosity)
      def logLinePrefix: Output[Option[String]] = output.map(_.logLinePrefix)
      def logMinDurationStatement: Output[Option[Int]] = output.map(_.logMinDurationStatement)
      def logTempFiles: Output[Option[Int]] = output.map(_.logTempFiles)
      def maxFilesPerProcess: Output[Option[Int]] = output.map(_.maxFilesPerProcess)
      def maxLocksPerTransaction: Output[Option[Int]] = output.map(_.maxLocksPerTransaction)
      def maxLogicalReplicationWorkers: Output[Option[Int]] = output.map(_.maxLogicalReplicationWorkers)
      def maxParallelWorkers: Output[Option[Int]] = output.map(_.maxParallelWorkers)
      def maxParallelWorkersPerGather: Output[Option[Int]] = output.map(_.maxParallelWorkersPerGather)
      def maxPredLocksPerTransaction: Output[Option[Int]] = output.map(_.maxPredLocksPerTransaction)
      def maxPreparedTransactions: Output[Option[Int]] = output.map(_.maxPreparedTransactions)
      def maxReplicationSlots: Output[Option[Int]] = output.map(_.maxReplicationSlots)
      def maxSlotWalKeepSize: Output[Option[Int]] = output.map(_.maxSlotWalKeepSize)
      def maxStackDepth: Output[Option[Int]] = output.map(_.maxStackDepth)
      def maxStandbyArchiveDelay: Output[Option[Int]] = output.map(_.maxStandbyArchiveDelay)
      def maxStandbyStreamingDelay: Output[Option[Int]] = output.map(_.maxStandbyStreamingDelay)
      def maxWalSenders: Output[Option[Int]] = output.map(_.maxWalSenders)
      def maxWorkerProcesses: Output[Option[Int]] = output.map(_.maxWorkerProcesses)
      def pgPartmanBgwDotInterval: Output[Option[Int]] = output.map(_.pgPartmanBgwDotInterval)
      def pgPartmanBgwDotRole: Output[Option[String]] = output.map(_.pgPartmanBgwDotRole)
      def pgStatMonitorDotPgsmEnableQueryPlan: Output[Option[Boolean]] = output.map(_.pgStatMonitorDotPgsmEnableQueryPlan)
      def pgStatMonitorDotPgsmMaxBuckets: Output[Option[Int]] = output.map(_.pgStatMonitorDotPgsmMaxBuckets)
      def pgStatStatementsDotTrack: Output[Option[String]] = output.map(_.pgStatStatementsDotTrack)
      def tempFileLimit: Output[Option[Int]] = output.map(_.tempFileLimit)
      def timezone: Output[Option[String]] = output.map(_.timezone)
      def trackActivityQuerySize: Output[Option[Int]] = output.map(_.trackActivityQuerySize)
      def trackCommitTimestamp: Output[Option[String]] = output.map(_.trackCommitTimestamp)
      def trackFunctions: Output[Option[String]] = output.map(_.trackFunctions)
      def trackIoTiming: Output[Option[String]] = output.map(_.trackIoTiming)
      def walSenderTimeout: Output[Option[Int]] = output.map(_.walSenderTimeout)
      def walWriterDelay: Output[Option[Int]] = output.map(_.walWriterDelay)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPgPgUserConfigPg]])
      def autovacuumAnalyzeScaleFactor: Output[Option[Double]] = output.map(_.flatMap(_.autovacuumAnalyzeScaleFactor))
      def autovacuumAnalyzeThreshold: Output[Option[Int]] = output.map(_.flatMap(_.autovacuumAnalyzeThreshold))
      def autovacuumFreezeMaxAge: Output[Option[Int]] = output.map(_.flatMap(_.autovacuumFreezeMaxAge))
      def autovacuumMaxWorkers: Output[Option[Int]] = output.map(_.flatMap(_.autovacuumMaxWorkers))
      def autovacuumNaptime: Output[Option[Int]] = output.map(_.flatMap(_.autovacuumNaptime))
      def autovacuumVacuumCostDelay: Output[Option[Int]] = output.map(_.flatMap(_.autovacuumVacuumCostDelay))
      def autovacuumVacuumCostLimit: Output[Option[Int]] = output.map(_.flatMap(_.autovacuumVacuumCostLimit))
      def autovacuumVacuumScaleFactor: Output[Option[Double]] = output.map(_.flatMap(_.autovacuumVacuumScaleFactor))
      def autovacuumVacuumThreshold: Output[Option[Int]] = output.map(_.flatMap(_.autovacuumVacuumThreshold))
      def bgwriterDelay: Output[Option[Int]] = output.map(_.flatMap(_.bgwriterDelay))
      def bgwriterFlushAfter: Output[Option[Int]] = output.map(_.flatMap(_.bgwriterFlushAfter))
      def bgwriterLruMaxpages: Output[Option[Int]] = output.map(_.flatMap(_.bgwriterLruMaxpages))
      def bgwriterLruMultiplier: Output[Option[Double]] = output.map(_.flatMap(_.bgwriterLruMultiplier))
      def deadlockTimeout: Output[Option[Int]] = output.map(_.flatMap(_.deadlockTimeout))
      def defaultToastCompression: Output[Option[String]] = output.map(_.flatMap(_.defaultToastCompression))
      def idleInTransactionSessionTimeout: Output[Option[Int]] = output.map(_.flatMap(_.idleInTransactionSessionTimeout))
      def jit: Output[Option[Boolean]] = output.map(_.flatMap(_.jit))
      def logAutovacuumMinDuration: Output[Option[Int]] = output.map(_.flatMap(_.logAutovacuumMinDuration))
      def logErrorVerbosity: Output[Option[String]] = output.map(_.flatMap(_.logErrorVerbosity))
      def logLinePrefix: Output[Option[String]] = output.map(_.flatMap(_.logLinePrefix))
      def logMinDurationStatement: Output[Option[Int]] = output.map(_.flatMap(_.logMinDurationStatement))
      def logTempFiles: Output[Option[Int]] = output.map(_.flatMap(_.logTempFiles))
      def maxFilesPerProcess: Output[Option[Int]] = output.map(_.flatMap(_.maxFilesPerProcess))
      def maxLocksPerTransaction: Output[Option[Int]] = output.map(_.flatMap(_.maxLocksPerTransaction))
      def maxLogicalReplicationWorkers: Output[Option[Int]] = output.map(_.flatMap(_.maxLogicalReplicationWorkers))
      def maxParallelWorkers: Output[Option[Int]] = output.map(_.flatMap(_.maxParallelWorkers))
      def maxParallelWorkersPerGather: Output[Option[Int]] = output.map(_.flatMap(_.maxParallelWorkersPerGather))
      def maxPredLocksPerTransaction: Output[Option[Int]] = output.map(_.flatMap(_.maxPredLocksPerTransaction))
      def maxPreparedTransactions: Output[Option[Int]] = output.map(_.flatMap(_.maxPreparedTransactions))
      def maxReplicationSlots: Output[Option[Int]] = output.map(_.flatMap(_.maxReplicationSlots))
      def maxSlotWalKeepSize: Output[Option[Int]] = output.map(_.flatMap(_.maxSlotWalKeepSize))
      def maxStackDepth: Output[Option[Int]] = output.map(_.flatMap(_.maxStackDepth))
      def maxStandbyArchiveDelay: Output[Option[Int]] = output.map(_.flatMap(_.maxStandbyArchiveDelay))
      def maxStandbyStreamingDelay: Output[Option[Int]] = output.map(_.flatMap(_.maxStandbyStreamingDelay))
      def maxWalSenders: Output[Option[Int]] = output.map(_.flatMap(_.maxWalSenders))
      def maxWorkerProcesses: Output[Option[Int]] = output.map(_.flatMap(_.maxWorkerProcesses))
      def pgPartmanBgwDotInterval: Output[Option[Int]] = output.map(_.flatMap(_.pgPartmanBgwDotInterval))
      def pgPartmanBgwDotRole: Output[Option[String]] = output.map(_.flatMap(_.pgPartmanBgwDotRole))
      def pgStatMonitorDotPgsmEnableQueryPlan: Output[Option[Boolean]] = output.map(_.flatMap(_.pgStatMonitorDotPgsmEnableQueryPlan))
      def pgStatMonitorDotPgsmMaxBuckets: Output[Option[Int]] = output.map(_.flatMap(_.pgStatMonitorDotPgsmMaxBuckets))
      def pgStatStatementsDotTrack: Output[Option[String]] = output.map(_.flatMap(_.pgStatStatementsDotTrack))
      def tempFileLimit: Output[Option[Int]] = output.map(_.flatMap(_.tempFileLimit))
      def timezone: Output[Option[String]] = output.map(_.flatMap(_.timezone))
      def trackActivityQuerySize: Output[Option[Int]] = output.map(_.flatMap(_.trackActivityQuerySize))
      def trackCommitTimestamp: Output[Option[String]] = output.map(_.flatMap(_.trackCommitTimestamp))
      def trackFunctions: Output[Option[String]] = output.map(_.flatMap(_.trackFunctions))
      def trackIoTiming: Output[Option[String]] = output.map(_.flatMap(_.trackIoTiming))
      def walSenderTimeout: Output[Option[Int]] = output.map(_.flatMap(_.walSenderTimeout))
      def walWriterDelay: Output[Option[Int]] = output.map(_.flatMap(_.walWriterDelay))


