package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPgPgUserConfigPgbouncer private(
  autodbIdleTimeout: Option[Int],
  autodbMaxDbConnections: Option[Int],
  autodbPoolMode: Option[String],
  autodbPoolSize: Option[Int],
  ignoreStartupParameters: Option[scala.collection.immutable.List[String]],
  minPoolSize: Option[Int],
  serverIdleTimeout: Option[Int],
  serverLifetime: Option[Int],
  serverResetQueryAlways: Option[Boolean]
) derives Decoder

object GetPgPgUserConfigPgbouncer:
  given outputOps: {} with
    extension(output: Output[GetPgPgUserConfigPgbouncer])
      def autodbIdleTimeout: Output[Option[Int]] = output.map(_.autodbIdleTimeout)
      def autodbMaxDbConnections: Output[Option[Int]] = output.map(_.autodbMaxDbConnections)
      def autodbPoolMode: Output[Option[String]] = output.map(_.autodbPoolMode)
      def autodbPoolSize: Output[Option[Int]] = output.map(_.autodbPoolSize)
      def ignoreStartupParameters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ignoreStartupParameters)
      def minPoolSize: Output[Option[Int]] = output.map(_.minPoolSize)
      def serverIdleTimeout: Output[Option[Int]] = output.map(_.serverIdleTimeout)
      def serverLifetime: Output[Option[Int]] = output.map(_.serverLifetime)
      def serverResetQueryAlways: Output[Option[Boolean]] = output.map(_.serverResetQueryAlways)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPgPgUserConfigPgbouncer]])
      def autodbIdleTimeout: Output[Option[Int]] = output.map(_.flatMap(_.autodbIdleTimeout))
      def autodbMaxDbConnections: Output[Option[Int]] = output.map(_.flatMap(_.autodbMaxDbConnections))
      def autodbPoolMode: Output[Option[String]] = output.map(_.flatMap(_.autodbPoolMode))
      def autodbPoolSize: Output[Option[Int]] = output.map(_.flatMap(_.autodbPoolSize))
      def ignoreStartupParameters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ignoreStartupParameters))
      def minPoolSize: Output[Option[Int]] = output.map(_.flatMap(_.minPoolSize))
      def serverIdleTimeout: Output[Option[Int]] = output.map(_.flatMap(_.serverIdleTimeout))
      def serverLifetime: Output[Option[Int]] = output.map(_.flatMap(_.serverLifetime))
      def serverResetQueryAlways: Output[Option[Boolean]] = output.map(_.flatMap(_.serverResetQueryAlways))


