package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetPgPgUserConfigPrivatelinkAccess private(
  pg: Option[Boolean],
  pgbouncer: Option[Boolean],
  prometheus: Option[Boolean]
) derives Decoder

object GetPgPgUserConfigPrivatelinkAccess:
  given outputOps: {} with
    extension(output: Output[GetPgPgUserConfigPrivatelinkAccess])
      def pg: Output[Option[Boolean]] = output.map(_.pg)
      def pgbouncer: Output[Option[Boolean]] = output.map(_.pgbouncer)
      def prometheus: Output[Option[Boolean]] = output.map(_.prometheus)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetPgPgUserConfigPrivatelinkAccess]])
      def pg: Output[Option[Boolean]] = output.map(_.flatMap(_.pg))
      def pgbouncer: Output[Option[Boolean]] = output.map(_.flatMap(_.pgbouncer))
      def prometheus: Output[Option[Boolean]] = output.map(_.flatMap(_.prometheus))


