package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetRedisRedisUserConfig private(
  additionalBackupRegions: Option[String],
  ipFilterObjects: Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetRedisRedisUserConfigIpFilterObject]],
  ipFilterStrings: Option[scala.collection.immutable.List[String]],
  ipFilters: Option[scala.collection.immutable.List[String]],
  migration: Option[besom.api.aiven.outputs.GetRedisRedisUserConfigMigration],
  privateAccess: Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPrivateAccess],
  privatelinkAccess: Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPrivatelinkAccess],
  projectToForkFrom: Option[String],
  publicAccess: Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPublicAccess],
  recoveryBasebackupName: Option[String],
  redisAclChannelsDefault: Option[String],
  redisIoThreads: Option[Int],
  redisLfuDecayTime: Option[Int],
  redisLfuLogFactor: Option[Int],
  redisMaxmemoryPolicy: Option[String],
  redisNotifyKeyspaceEvents: Option[String],
  redisNumberOfDatabases: Option[Int],
  redisPersistence: Option[String],
  redisPubsubClientOutputBufferLimit: Option[Int],
  redisSsl: Option[Boolean],
  redisTimeout: Option[Int],
  serviceToForkFrom: Option[String],
  staticIps: Option[Boolean]
) derives Decoder

object GetRedisRedisUserConfig:
  given outputOps: {} with
    extension(output: Output[GetRedisRedisUserConfig])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.additionalBackupRegions)
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetRedisRedisUserConfigIpFilterObject]]] = output.map(_.ipFilterObjects)
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilterStrings)
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.ipFilters)
      def migration: Output[Option[besom.api.aiven.outputs.GetRedisRedisUserConfigMigration]] = output.map(_.migration)
      def privateAccess: Output[Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPrivateAccess]] = output.map(_.privateAccess)
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPrivatelinkAccess]] = output.map(_.privatelinkAccess)
      def projectToForkFrom: Output[Option[String]] = output.map(_.projectToForkFrom)
      def publicAccess: Output[Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPublicAccess]] = output.map(_.publicAccess)
      def recoveryBasebackupName: Output[Option[String]] = output.map(_.recoveryBasebackupName)
      def redisAclChannelsDefault: Output[Option[String]] = output.map(_.redisAclChannelsDefault)
      def redisIoThreads: Output[Option[Int]] = output.map(_.redisIoThreads)
      def redisLfuDecayTime: Output[Option[Int]] = output.map(_.redisLfuDecayTime)
      def redisLfuLogFactor: Output[Option[Int]] = output.map(_.redisLfuLogFactor)
      def redisMaxmemoryPolicy: Output[Option[String]] = output.map(_.redisMaxmemoryPolicy)
      def redisNotifyKeyspaceEvents: Output[Option[String]] = output.map(_.redisNotifyKeyspaceEvents)
      def redisNumberOfDatabases: Output[Option[Int]] = output.map(_.redisNumberOfDatabases)
      def redisPersistence: Output[Option[String]] = output.map(_.redisPersistence)
      def redisPubsubClientOutputBufferLimit: Output[Option[Int]] = output.map(_.redisPubsubClientOutputBufferLimit)
      def redisSsl: Output[Option[Boolean]] = output.map(_.redisSsl)
      def redisTimeout: Output[Option[Int]] = output.map(_.redisTimeout)
      def serviceToForkFrom: Output[Option[String]] = output.map(_.serviceToForkFrom)
      def staticIps: Output[Option[Boolean]] = output.map(_.staticIps)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetRedisRedisUserConfig]])
      def additionalBackupRegions: Output[Option[String]] = output.map(_.flatMap(_.additionalBackupRegions))
      def ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetRedisRedisUserConfigIpFilterObject]]] = output.map(_.flatMap(_.ipFilterObjects))
      def ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilterStrings))
      def ipFilters: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.ipFilters))
      def migration: Output[Option[besom.api.aiven.outputs.GetRedisRedisUserConfigMigration]] = output.map(_.flatMap(_.migration))
      def privateAccess: Output[Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPrivateAccess]] = output.map(_.flatMap(_.privateAccess))
      def privatelinkAccess: Output[Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPrivatelinkAccess]] = output.map(_.flatMap(_.privatelinkAccess))
      def projectToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.projectToForkFrom))
      def publicAccess: Output[Option[besom.api.aiven.outputs.GetRedisRedisUserConfigPublicAccess]] = output.map(_.flatMap(_.publicAccess))
      def recoveryBasebackupName: Output[Option[String]] = output.map(_.flatMap(_.recoveryBasebackupName))
      def redisAclChannelsDefault: Output[Option[String]] = output.map(_.flatMap(_.redisAclChannelsDefault))
      def redisIoThreads: Output[Option[Int]] = output.map(_.flatMap(_.redisIoThreads))
      def redisLfuDecayTime: Output[Option[Int]] = output.map(_.flatMap(_.redisLfuDecayTime))
      def redisLfuLogFactor: Output[Option[Int]] = output.map(_.flatMap(_.redisLfuLogFactor))
      def redisMaxmemoryPolicy: Output[Option[String]] = output.map(_.flatMap(_.redisMaxmemoryPolicy))
      def redisNotifyKeyspaceEvents: Output[Option[String]] = output.map(_.flatMap(_.redisNotifyKeyspaceEvents))
      def redisNumberOfDatabases: Output[Option[Int]] = output.map(_.flatMap(_.redisNumberOfDatabases))
      def redisPersistence: Output[Option[String]] = output.map(_.flatMap(_.redisPersistence))
      def redisPubsubClientOutputBufferLimit: Output[Option[Int]] = output.map(_.flatMap(_.redisPubsubClientOutputBufferLimit))
      def redisSsl: Output[Option[Boolean]] = output.map(_.flatMap(_.redisSsl))
      def redisTimeout: Output[Option[Int]] = output.map(_.flatMap(_.redisTimeout))
      def serviceToForkFrom: Output[Option[String]] = output.map(_.flatMap(_.serviceToForkFrom))
      def staticIps: Output[Option[Boolean]] = output.map(_.flatMap(_.staticIps))


