package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetRedisRedisUserConfigMigration private(
  dbname: Option[String],
  host: String,
  ignoreDbs: Option[String],
  method: Option[String],
  password: Option[String],
  port: Int,
  ssl: Option[Boolean],
  username: Option[String]
) derives Decoder

object GetRedisRedisUserConfigMigration:
  given outputOps: {} with
    extension(output: Output[GetRedisRedisUserConfigMigration])
      def dbname: Output[Option[String]] = output.map(_.dbname)
      def host: Output[String] = output.map(_.host)
      def ignoreDbs: Output[Option[String]] = output.map(_.ignoreDbs)
      def method: Output[Option[String]] = output.map(_.method)
      def password: Output[Option[String]] = output.map(_.password)
      def port: Output[Int] = output.map(_.port)
      def ssl: Output[Option[Boolean]] = output.map(_.ssl)
      def username: Output[Option[String]] = output.map(_.username)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetRedisRedisUserConfigMigration]])
      def dbname: Output[Option[String]] = output.map(_.flatMap(_.dbname))
      def host: Output[Option[String]] = output.map(_.map(_.host))
      def ignoreDbs: Output[Option[String]] = output.map(_.flatMap(_.ignoreDbs))
      def method: Output[Option[String]] = output.map(_.flatMap(_.method))
      def password: Output[Option[String]] = output.map(_.flatMap(_.password))
      def port: Output[Option[Int]] = output.map(_.map(_.port))
      def ssl: Output[Option[Boolean]] = output.map(_.flatMap(_.ssl))
      def username: Output[Option[String]] = output.map(_.flatMap(_.username))


