package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetRedisServiceIntegration private(
  integrationType: String,
  sourceServiceName: String
) derives Decoder

object GetRedisServiceIntegration:
  given outputOps: {} with
    extension(output: Output[GetRedisServiceIntegration])
      def integrationType: Output[String] = output.map(_.integrationType)
      def sourceServiceName: Output[String] = output.map(_.sourceServiceName)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetRedisServiceIntegration]])
      def integrationType: Output[Option[String]] = output.map(_.map(_.integrationType))
      def sourceServiceName: Output[Option[String]] = output.map(_.map(_.sourceServiceName))


