package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationDatadogUserConfig private(
  datadogDbmEnabled: Option[Boolean],
  datadogTags: Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigDatadogTag]],
  excludeConsumerGroups: Option[scala.collection.immutable.List[String]],
  excludeTopics: Option[scala.collection.immutable.List[String]],
  includeConsumerGroups: Option[scala.collection.immutable.List[String]],
  includeTopics: Option[scala.collection.immutable.List[String]],
  kafkaCustomMetrics: Option[scala.collection.immutable.List[String]],
  maxJmxMetrics: Option[Int],
  opensearch: Option[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigOpensearch],
  redis: Option[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigRedis]
) derives Decoder

object GetServiceIntegrationDatadogUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationDatadogUserConfig])
      def datadogDbmEnabled: Output[Option[Boolean]] = output.map(_.datadogDbmEnabled)
      def datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigDatadogTag]]] = output.map(_.datadogTags)
      def excludeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.excludeConsumerGroups)
      def excludeTopics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.excludeTopics)
      def includeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.includeConsumerGroups)
      def includeTopics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.includeTopics)
      def kafkaCustomMetrics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.kafkaCustomMetrics)
      def maxJmxMetrics: Output[Option[Int]] = output.map(_.maxJmxMetrics)
      def opensearch: Output[Option[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigOpensearch]] = output.map(_.opensearch)
      def redis: Output[Option[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigRedis]] = output.map(_.redis)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationDatadogUserConfig]])
      def datadogDbmEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.datadogDbmEnabled))
      def datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigDatadogTag]]] = output.map(_.flatMap(_.datadogTags))
      def excludeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.excludeConsumerGroups))
      def excludeTopics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.excludeTopics))
      def includeConsumerGroups: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.includeConsumerGroups))
      def includeTopics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.includeTopics))
      def kafkaCustomMetrics: Output[Option[scala.collection.immutable.List[String]]] = output.map(_.flatMap(_.kafkaCustomMetrics))
      def maxJmxMetrics: Output[Option[Int]] = output.map(_.flatMap(_.maxJmxMetrics))
      def opensearch: Output[Option[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigOpensearch]] = output.map(_.flatMap(_.opensearch))
      def redis: Output[Option[besom.api.aiven.outputs.GetServiceIntegrationDatadogUserConfigRedis]] = output.map(_.flatMap(_.redis))


