package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationDatadogUserConfigOpensearch private(
  indexStatsEnabled: Option[Boolean],
  pendingTaskStatsEnabled: Option[Boolean],
  pshardStatsEnabled: Option[Boolean]
) derives Decoder

object GetServiceIntegrationDatadogUserConfigOpensearch:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationDatadogUserConfigOpensearch])
      def indexStatsEnabled: Output[Option[Boolean]] = output.map(_.indexStatsEnabled)
      def pendingTaskStatsEnabled: Output[Option[Boolean]] = output.map(_.pendingTaskStatsEnabled)
      def pshardStatsEnabled: Output[Option[Boolean]] = output.map(_.pshardStatsEnabled)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationDatadogUserConfigOpensearch]])
      def indexStatsEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.indexStatsEnabled))
      def pendingTaskStatsEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.pendingTaskStatsEnabled))
      def pshardStatsEnabled: Output[Option[Boolean]] = output.map(_.flatMap(_.pshardStatsEnabled))


