package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationEndpointDatadogUserConfig private(
  datadogApiKey: String,
  datadogTags: Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetServiceIntegrationEndpointDatadogUserConfigDatadogTag]],
  disableConsumerStats: Option[Boolean],
  kafkaConsumerCheckInstances: Option[Int],
  kafkaConsumerStatsTimeout: Option[Int],
  maxPartitionContexts: Option[Int],
  site: Option[String]
) derives Decoder

object GetServiceIntegrationEndpointDatadogUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationEndpointDatadogUserConfig])
      def datadogApiKey: Output[String] = output.map(_.datadogApiKey)
      def datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetServiceIntegrationEndpointDatadogUserConfigDatadogTag]]] = output.map(_.datadogTags)
      def disableConsumerStats: Output[Option[Boolean]] = output.map(_.disableConsumerStats)
      def kafkaConsumerCheckInstances: Output[Option[Int]] = output.map(_.kafkaConsumerCheckInstances)
      def kafkaConsumerStatsTimeout: Output[Option[Int]] = output.map(_.kafkaConsumerStatsTimeout)
      def maxPartitionContexts: Output[Option[Int]] = output.map(_.maxPartitionContexts)
      def site: Output[Option[String]] = output.map(_.site)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationEndpointDatadogUserConfig]])
      def datadogApiKey: Output[Option[String]] = output.map(_.map(_.datadogApiKey))
      def datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.GetServiceIntegrationEndpointDatadogUserConfigDatadogTag]]] = output.map(_.flatMap(_.datadogTags))
      def disableConsumerStats: Output[Option[Boolean]] = output.map(_.flatMap(_.disableConsumerStats))
      def kafkaConsumerCheckInstances: Output[Option[Int]] = output.map(_.flatMap(_.kafkaConsumerCheckInstances))
      def kafkaConsumerStatsTimeout: Output[Option[Int]] = output.map(_.flatMap(_.kafkaConsumerStatsTimeout))
      def maxPartitionContexts: Output[Option[Int]] = output.map(_.flatMap(_.maxPartitionContexts))
      def site: Output[Option[String]] = output.map(_.flatMap(_.site))


