package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig private(
  accessKey: String,
  logGroupName: Option[String],
  region: String,
  secretKey: String
) derives Decoder

object GetServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig])
      def accessKey: Output[String] = output.map(_.accessKey)
      def logGroupName: Output[Option[String]] = output.map(_.logGroupName)
      def region: Output[String] = output.map(_.region)
      def secretKey: Output[String] = output.map(_.secretKey)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig]])
      def accessKey: Output[Option[String]] = output.map(_.map(_.accessKey))
      def logGroupName: Output[Option[String]] = output.map(_.flatMap(_.logGroupName))
      def region: Output[Option[String]] = output.map(_.map(_.region))
      def secretKey: Output[Option[String]] = output.map(_.map(_.secretKey))


