package besom.api.aiven.outputs

import besom.types.Output
import besom.types.Context
import besom.types.Decoder


final case class GetServiceIntegrationEndpointJolokiaUserConfig private(
  basicAuthPassword: Option[String],
  basicAuthUsername: Option[String]
) derives Decoder

object GetServiceIntegrationEndpointJolokiaUserConfig:
  given outputOps: {} with
    extension(output: Output[GetServiceIntegrationEndpointJolokiaUserConfig])
      def basicAuthPassword: Output[Option[String]] = output.map(_.basicAuthPassword)
      def basicAuthUsername: Output[Option[String]] = output.map(_.basicAuthUsername)

  given optionOutputOps: {} with
    extension(output: Output[Option[GetServiceIntegrationEndpointJolokiaUserConfig]])
      def basicAuthPassword: Output[Option[String]] = output.map(_.flatMap(_.basicAuthPassword))
      def basicAuthUsername: Output[Option[String]] = output.map(_.flatMap(_.basicAuthUsername))


